// Copyright 1994 Altera Corporation
// Verilog example
// Description : 4 bit up counter with asynchronous reset
//                               and synchronous load with enable.
//

module count4 (qout, data, clock, enable, reset, load);
output [3:0] qout;
input [3:0] data;
input clock, enable, reset, load;
reg [3:0] reg_q;

always @(posedge clock)
  begin
	if(load == 1)
		reg_q = data;
	else 
		reg_q = reg_q +1;
  end

always @(reset)
  begin
	if(reset == 1)
		assign reg_q = 0;
	else
		deassign reg_q;
  end

assign qout = (enable == 1) ? reg_q: qout;

endmodule


